﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using FDK;

namespace StrokeStyleT
{
	class C演奏ステージ : CActivity
	{
		public int n描画開始チップ番号 = -1;
		public Dictionary<Eヒット判定, int> dicヒットした回数 { get; protected set; }
		public bool b演奏終了済み { get { return ( this.n描画開始チップ番号 < 0 ); } }

		public C演奏ステージ()
		{
			this.list子Activities.Add( this.act背景 = new CAct背景() );
			this.list子Activities.Add( this.actステージキット = new CActステージキット() );
			this.list子Activities.Add( this.actドラムキット = new CActドラムキット() );
		}

		public E演奏レーン tチップが属する演奏レーンを返す( Eチップ種別 eチップ )
		{
			foreach( var kvp in C演奏ステージ.dic演奏レーンtoチップ )
			{
				if( kvp.Value.Contains( eチップ ) )
					return kvp.Key;
			}
			return E演奏レーン.Unknown;
		}
		public E演奏レーン tチップが属する演奏レーンを返す( Cチップ cc )
		{
			return this.tチップが属する演奏レーンを返す( cc.eチップ種別 );
		}

		protected override void Onデバイスリソースの作成()
		{
			Global.tデバイスをロックして処理を行う( ( hLockedDevice ) => {

				this.txドラムチップ = new CTexture( hLockedDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\Drum Chips.png" ) );
				this.txスコアフレーム = new CTexture( hLockedDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\ScreenPlay ScoreFrame.png" ) );
				this.tx判定バー = new CTexture( hLockedDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\ScreenPlay HitBar.png" ) );

			} );

			Cチップ.t全チップのデバイスリソースの作成();
		}
		protected override void Onデバイスリソースの解放()
		{
			if( this.txドラムチップ != null )
				this.txドラムチップ = null;

			if( this.txスコアフレーム != null )
				this.txスコアフレーム.Dispose();

			if( this.tx判定バー != null )
				this.tx判定バー.Dispose();

			Cチップ.t全チップのデバイスリソースの解放();
		}

		protected override void On活性化()
		{
			this.n描画開始チップ番号 = 0;
			this.b背景動画チップの発火を待たずに最初の進行で背景動画の再生を開始する = false;
			this.dicヒットした回数 = new Dictionary<Eヒット判定, int>();
			foreach( var obj in Enum.GetValues( typeof( Eヒット判定 ) ) )
				this.dicヒットした回数.Add( (Eヒット判定) obj, 0);
			this.ctチップアニメ = new CCounter( 0, 48, 10 );

			User user = Global.Users.SelectedUser;
			Song song = user.Songs.SelectedSong;
			Options options = user.Options;

			#region [ 背景動画を生成。]
			//-----------------
			if( song != null )
			{
				try
				{
					song.ms背景動画 = new CMediaSession( Program.App.hWindow, song.stg背景動画ファイルパス, b音声あり: false, bループする: false );
					Trace.TraceInformation( "動画を生成しました。({0})", Path.GetFileName( song.stg背景動画ファイルパス ) );
				}
				catch( Exception e )
				{
					Trace.TraceWarning( "動画の生成に失敗しました。({0})", Global.Folders.tファイルパスをマクロ付きパスに変換する( song.stg背景動画ファイルパス ) );
					Utils.t例外の詳細をログに出力する( e );
					song.ms背景動画 = null;
				}
			}
			//-----------------
			#endregion

			#region [ 各チップの発声時刻に、再生遅延を反映。]
			//-----------------
			int n再生遅延ms = 0;	// 描画されるチップよりどれだけ先に発声するか？（例: n再生遅延ms = 10 → チップが判定バー上に描画されるより 10ms 前に発声する。）

			int n作成時のバッファ長bytes = song.n作成時のWASAPIバッファ長bytes;
			if( n作成時のバッファ長bytes > 0 )		// 記載されていて、かつ、0ms を超える値である場合に（他の値も）有効値と見なす。
			{
				#region [ 相対的な再生遅延量を計算する。]
				//-----------------
				var sound = Global.Sound;

				int n作成時のバッファ長ms =
					( n作成時のバッファ長bytes * 1000 ) / ( song.n作成時のWASAPIサンプリングバイト数 * song.n作成時のWASAPI周波数Hz * song.n作成時のWASAPIチャンネル数 );

				int n演奏時のバッファ長ms =
					( sound.nバッファ長bytes * 1000 ) / ( sound.nサンプリングバイト数 * sound.nサンプリング周波数Hz * sound.nチャンネル数 );

				n再生遅延ms = n演奏時のバッファ長ms - n作成時のバッファ長ms;
				//-----------------
				#endregion

				#region [ BGM の発声位置を n再生遅延ms 前に修正する。]
				//-----------------
				if( song.sdBGM != null )
				{
					if( this.b背景動画チップの発火を待たずに最初の進行で背景動画の再生を開始する )
					{
						#region [ (A) 既に背景動画チップがヒット処理されている場合 → 動画とBGMの再生開始位置をずらす ]
						//-----------------
						long n新しい再生開始位置ms = Math.Max( song.ms背景動画.n現在のグラフの再生位置ms - n再生遅延ms, 0 );	// 再生位置が負数になった場合は 0 とする。

						song.ms背景動画.t再生する( (ulong) ( n新しい再生開始位置ms * 1000 * 10 ) );	// 100ns 単位で指定。
						song.sdBGM.t再生位置を変更する( n新しい再生開始位置ms );
						//-----------------
						#endregion
					}
					else
					{
						#region [ (B) まだ背景動画チップがヒット処理されていない場合 → 背景動画チップの発声時刻をずらす ]
						//-----------------
						foreach( var chip in song.listチップ )
						{
							if( chip.eチップ種別 == Eチップ種別.背景動画 )
							{
								// 発声時刻をずらす。

								chip.n発声時刻ms -= n再生遅延ms;


								// 発声時刻が負数になった場合は、プレイヤーモードと同じ方法で、いきなり途中から再生を開始する準備をする。

								if( chip.n発声時刻ms < 0 )
								{
									long n超過分ms = -chip.n発声時刻ms;

									song.ms背景動画.t再生する( (ulong) ( n超過分ms * 1000 * 10 ) );
									song.sdBGM.t再生位置を変更する( n超過分ms );

									this.b背景動画チップの発火を待たずに最初の進行で背景動画の再生を開始する = true;

									chip.bヒット済み = true;	// 既にヒットしたことになる。
									chip.b可視 = false;
								}

								break;
							}
						}
						//-----------------
						#endregion
					}
				}
				//-----------------
				#endregion

				#region [ 自動演奏 ON の場合、ドラムチップの発声時刻を修正する。]
				//-----------------
				if( song != null && options.b自動演奏 )
				{
					foreach( var chip in song.listチップ )
					{
						if( Cチップ.dicチップ種別toドラム入力[chip.eチップ種別].Count > 0 )
						{
							chip.n発声時刻ms -= n再生遅延ms;
							break;
						}
					}
				}
				//-----------------
				#endregion
			}
			else
			{
				Trace.TraceWarning( "この曲データには、サウンドデバイス情報の記載が不足しています。演奏時に音ズレが発生する恐れがあります。" );
			}
			//-----------------
			#endregion
		}
		protected override void On非活性化()
		{
			this.FPS.Dispose();
			this.VPS.Dispose();
			this.ctチップアニメ.Dispose();
		}
		protected override int On進行()
		{
			// タイマの更新と描画開始チップの決定。

			User user = Global.Users.SelectedUser;
			Song song = user.Songs.SelectedSong;

			#region [ 初めての進行（演奏開始）]
			//-----------------
			if( this.b初めての進行 )
			{
				// 指示があれば背景動画を再生開始。

				if( this.b背景動画チップの発火を待たずに最初の進行で背景動画の再生を開始する )
				{
					// 背景動画を再生開始。BGMも背景動画に同期して再生開始する。
					song.ms背景動画.t再生する( 0, song.sdBGM );
				}

	
				// 現在蓄積されているバッファ入力をすべてポーリング（＝クリア）する。

				Global.Input.tポーリング();
				
				
				// FPS/VPS 測定開始。

				this.FPS = new CFPS();
				this.VPS = new CFPS();


				// 演奏タイマをリセットする。
				// ・プレイヤーモード時は途中から開始されることが多いので、this.nプレイヤーモード時の演奏開始時刻ms を加算する。（通常演奏では 0）。
				// ・また、チップ発声時刻シフト値（Global.Global.Song.r現在演奏中の曲のスコア.r環境依存プロパティ.nチップ発声時刻シフト値ms）を加算する必要は無い。
				//　（加算は Act演奏チップ にて行われるため。）

				Global.SoundTimer.tリセット();
				//CApplication.SoundTimer.n現在時刻ms = this.nプレイヤーモード時の演奏開始時刻ms;

			
				this.b初めての進行 = false;
			}
			//-----------------
			#endregion

			#region [ 譜面データ自体空っぽならステージクリア。]
			//-----------------
			if( song.listチップ != null && song.listチップ.Count == 0 )
			{
				this.n描画開始チップ番号 = -1;
				return (int) E進行結果.クリア;
			}
			//-----------------
			#endregion
			#region [ タイマ更新。]
			//-----------------
			Global.SoundTimer.t更新();
			//-----------------
			#endregion
			#region [ 描画開始チップ交代？]
			//-----------------
			if( this.n描画開始チップ番号 >= 0 )
			{
				int nヒットバーとチップの距離符号付きpx =
					this.n指定された時間msに対応する符号付きピクセル数を返す( Global.SoundTimer.n現在時刻ms - song.listチップ[ this.n描画開始チップ番号 ].n描画時刻ms );

				int nチップのY座標 = 
					Theme.sz描画サイズ原寸px.Height - Theme.n画面下端からヒットバー中央までの距離px + nヒットバーとチップの距離符号付きpx;


				// チップのY座標が画面下外に出ていれば、描画開始チップ番号を１つ後ろのチップに交代する。後ろのチップがなければ -1（演奏終了）。

				if( nチップのY座標 > Theme.sz描画サイズ原寸px.Height + 20 )	// +20 は適当なマージン
				{
					this.n描画開始チップ番号++;

					if( this.n描画開始チップ番号 >= song.listチップ.Count )
						this.n描画開始チップ番号 = -1;		// 演奏終了。
				}
			}
			//-----------------
			#endregion
			#region [ 譜面が終了したならステージクリア。]
			//-----------------
			if( this.n描画開始チップ番号 < 0 )
				return (int) E進行結果.クリア;
			//-----------------
			#endregion

			#region [ FPS 更新 ]
			//-----------------
			this.FPS.tカウンタ更新();
			//-----------------
			#endregion
			#region [ 背景動画 ]
			//-----------------
			if( song.chip背景動画 != null && song.chip背景動画.bヒットしてない )
			{
				// n距離px = ヒットバーとチップの距離[pixel;符号付き]を算出する。
				// ・背景動画チップにはチップシフトは反映されない。
				// ・背景動画チップの再生遅延は、チップを移動することで既に反映済み（On活性化()参照）。

				int n距離px = this.n指定された時間msに対応する符号付きピクセル数を返す( Global.SoundTimer.n現在時刻ms - song.chip背景動画.n発声時刻ms );


				// 背景動画チップのヒット判定と処理。

				if( n距離px >= 0 )
				{
					song.ms背景動画.t再生する( 0 );		// 動画開始
					song.sdBGM.t先頭から再生する();		// 音声開始

					song.chip背景動画.bヒット済み = true;
					song.chip背景動画.b可視 = false;
				}
			}
			//-----------------
			#endregion
			#region [ 譜面 ]
			//-------------------------
			this.ctチップアニメ.t進行Loop();

			for( int i = this.n描画開始チップ番号; i < song.listチップ.Count; i++ )
			{
				var cc = song.listチップ[ i ];

				#region [ チップが発声対象じゃないならスキップ。]
				//-----------------
				if( cc.eチップ種別 == Eチップ種別.BPM ||
					cc.eチップ種別 == Eチップ種別.背景動画 ||
					cc.eチップ種別 == Eチップ種別.小節メモ )
					continue;
				//-----------------
				#endregion


				// n描画時間差ms, n発声時間差ms を算出。

				long n描画時間差ms = Global.SoundTimer.n現在時刻ms - cc.n描画時刻ms;
				long n発声時間差ms = Global.SoundTimer.n現在時刻ms - cc.n発声時刻ms;


				#region [ 描画時間差 が PoorRange を正方向に超えているなら Miss を発火。]
				//-------------------------
				if( cc.eチップ種別 != Eチップ種別.BPM &&
					cc.eチップ種別 != Eチップ種別.背景動画 &&
					cc.eチップ種別 != Eチップ種別.小節メモ &&
					cc.bヒットしてない &&
					n描画時間差ms > user.Options.dicヒット判定toRange[ Eヒット判定.POOR ] )
				{
					if( cc.eチップ種別 == Eチップ種別.SnareGhost ||
						cc.eチップ種別 == Eチップ種別.FootPedal )
					{
						// スネアゴーストとフットペダルについては、Miss 判定を行わない。
					}
					else
					{
						// 判定文字列(MISS)表示。
						//this.Act演奏判定文字列.t表示( this.tチップが属する演奏レーンを返す( cc ), Eヒット判定.MISS );S

						// COMBOリセット。
						//this.Act演奏コンボ.nCOMBO値 = 0;
					}
					cc.bヒット済み = true;
				}
				//-------------------------
				#endregion

				
				// 判定バーとチップの距離（符号付き）を算出する。

				int n描画距離px = this.n指定された時間msに対応する符号付きピクセル数を返す( n描画時間差ms );
				int n発声距離px = this.n指定された時間msに対応する符号付きピクセル数を返す( n発声時間差ms );


				// チップのY座標を算出する。y が画面上外に出ていればそこでループ終了。

				int y = Global.App.Window.ClientSize.Height - Theme.n画面下端からヒットバー中央までの距離px + n描画距離px;
				if( y < -20 )	// -20 は適当なマージン
					break;


				// オートチップの自動発声処理。

				if( user.Options.b自動演奏 && Cチップ.dicチップ種別toドラム入力[ cc.eチップ種別 ].Count > 0 )
				{
					if( cc.b発声してない && n発声距離px >= 0 )
					{
						// 発声する。

						Cチップ.tチップサウンドを再生する( cc.eチップ種別 );
						cc.b発声済み = true;
					}

					if( cc.bヒットしてない && n描画距離px >= 0 )
					{
						// ヒット処理をする。

						if( cc.eチップ種別 != Eチップ種別.SnareGhost && cc.eチップ種別 != Eチップ種別.FootPedal ) // Snare_Ghost と FootPedal はヒット対象としない。Missにもならない。
						{
							//this.Act演奏パッド.tヒット( lane );					// パッドアニメ開始。
							//this.Act演奏チップファイア.t発火( lane, 0 );		// チップファイア発火。
							//if( this.Act演奏ビッグファイア.b発火する( cc ) )
							//	this.Act演奏ビッグファイア.t発火();				// ビッグファイア発火。

							//this.Act演奏判定文字列.t表示( lane, E判定.AUTO );	// 判定文字列(AUTO)表示。
							//Global.Stage.演奏.dicヒットした回数[ E判定.AUTO ]++;// 判定別ヒット回数の増加。
							//if( Global.User.Config.b全オートである )
							//	this.Act演奏コンボ.nCOMBO値++;					// 全AUTOのときだけCOMBO増加。
						}
					}
				}
			}
			//-------------------------
			#endregion



			// 入力。

			#region [ ESC → キャンセル ]
			//-----------------
			if( Global.Input.Keyboard.bキーが押された( Key.Escape ) )
				return (int) E進行結果.キャンセル;
			//-----------------
			#endregion



			return (int) E進行結果.継続;
		}
		protected override void On描画( IntPtr hDevice )
		{
			Song song = Global.Users.SelectedUser.Songs.SelectedSong;

			#region [ VPS 更新 ]
			//-----------------
			if( this.VPS != null )	// 曲が再生されるまでは、この描画メソッドは呼ばれるが VPS は生成されていない。
				this.VPS.tカウンタ更新();
			//-----------------
			#endregion

			#region [ 背景 ]
			//-----------------
			this.act背景.t描画( hDevice );
			//-----------------
			#endregion
			#region [ 背景動画 ]
			//-----------------
			if( song.chip背景動画 != null && song.chip背景動画.bヒット済み && song.ms背景動画 != null )
			{
				// 表示位置とサイズは固定。
				song.ms背景動画.t最新のサンプルを描画する( x:447, y:178, w:1024, h:576 );
			}
			//-----------------
			#endregion
			#region [ ステージキット ]
			//-----------------
			this.actステージキット.t描画( hDevice );
			//-----------------
			#endregion
			#region [ スコアフレーム ]
			//-----------------
			if( this.txスコアフレーム != null )
				this.txスコアフレーム.t2D描画( hDevice, 625, 0 );
			//-----------------
			#endregion
			#region [ 譜面（小節線、拍線）]
			//-------------------------
			for( int i = this.n描画開始チップ番号; i < song.listチップ.Count; i++ )
			{
				var cc = song.listチップ[ i ];

				#region [ チップが描画対象じゃないならスキップ。]
				//-----------------
				if( cc.eチップ種別 != Eチップ種別.小節線 &&
					cc.eチップ種別 != Eチップ種別.拍線 )
					continue;
				//-----------------
				#endregion


				// 時間差を算出する。

				long n描画時間差ms = Global.SoundTimer.n現在時刻ms - cc.n描画時刻ms;


				// ヒットバーとチップの距離[pixel;符号付き]を算出する。

				int n描画距離px = this.n指定された時間msに対応する符号付きピクセル数を返す( n描画時間差ms );


				// チップのY座標を算出する。y が画面上外に出ていればそこでループ終了。

				int y = Global.App.Window.ClientSize.Height - Theme.n画面下端からヒットバー中央までの距離px + n描画距離px;
				if( y < -20 )	// -20 は適当なマージン
					break;


				// 描画。

				if( cc.b可視 )
				{
					// 画像は幅 300px しかないので、２つ横につなげて600pxにする。

					Cチップ.tチップの画像を描画する( hDevice, cc, 654 + 150, y, 0 );
					Cチップ.tチップの画像を描画する( hDevice, cc, 654 + 450, y, 0 );
				}
			}
			//-------------------------
			#endregion
			#region [ 判定バー ]
			//-----------------
			if( this.tx判定バー != null )
				this.tx判定バー.t2D描画( hDevice, 612, 877 );
			//-----------------
			#endregion
			#region [ ドラムキット ]
			//-----------------
			this.actドラムキット.t描画( hDevice );
			//-----------------
			#endregion
			#region [ 譜面 ]
			//-------------------------
			for( int i = this.n描画開始チップ番号; i < song.listチップ.Count; i++ )
			{
				var cc = song.listチップ[ i ];

				#region [ チップが描画対象じゃないならスキップ。]
				//-----------------
				if( cc.eチップ種別 == Eチップ種別.小節線 ||
					cc.eチップ種別 == Eチップ種別.拍線 ||
					cc.eチップ種別 == Eチップ種別.BPM ||
					cc.eチップ種別 == Eチップ種別.背景動画 ||
					cc.eチップ種別 == Eチップ種別.小節メモ )
					continue;
				//-----------------
				#endregion


				// 時間差を算出する。

				long n描画時間差ms = Global.SoundTimer.n現在時刻ms - cc.n描画時刻ms;


				// ヒットバーとチップの距離[pixel;符号付き]を算出する。

				int n描画距離px = this.n指定された時間msに対応する符号付きピクセル数を返す( n描画時間差ms );


				// チップのY座標を算出する。y が画面上外に出ていればそこでループ終了。

				int y = Global.App.Window.ClientSize.Height - Theme.n画面下端からヒットバー中央までの距離px + n描画距離px;
				if( y < -20 )	// -20 は適当なマージン
					break;

				
				// チップのX座標を算出して描画する。

				E演奏レーン e演奏レーン = E演奏レーン.Unknown;
				foreach( var kvp in C演奏ステージ.dic演奏レーンtoチップ )
				{
					if( kvp.Value.Contains( cc.eチップ種別 ) )
					{
						e演奏レーン = kvp.Key;
						break;
					}
				}

				if( e演奏レーン == E演奏レーン.Unknown )
					continue;

				int x = C演奏ステージ.dic演奏レーンto中央Xpt[ e演奏レーン ];

				if( cc.b可視 )
					Cチップ.tチップの画像を描画する( hDevice, cc, x, y, this.ctチップアニメ.n現在の値 );
			}
			//-------------------------
			#endregion
		}

		private bool b背景動画チップの発火を待たずに最初の進行で背景動画の再生を開始する = false;
		private CTexture txドラムチップ = null;
		private CTexture txスコアフレーム = null;
		private CTexture tx判定バー = null;
		private CAct背景 act背景 = null;
		private CActステージキット actステージキット = null;
		private CActドラムキット actドラムキット = null;
		private CFPS FPS = null;
		private CFPS VPS = null;
		private CCounter ctチップアニメ = null;

		#region [ 演奏レーン to List<Eチップ種別>（static）]
		//-------------------------
		private static readonly Dictionary<E演奏レーン, List<Eチップ種別>> dic演奏レーンtoチップ = new Dictionary<E演奏レーン, List<Eチップ種別>>()
		{
			{ E演奏レーン.LeftCymbal, new List<Eチップ種別>() { Eチップ種別.LeftCrash, Eチップ種別.LeftChina, Eチップ種別.LeftCymbalMute, Eチップ種別.LeftRide, Eチップ種別.LeftRideCup, Eチップ種別.LeftSplash } },
			{ E演奏レーン.FootPedal, new List<Eチップ種別>() { Eチップ種別.FootPedal } },
			{ E演奏レーン.HiHat, new List<Eチップ種別>() { Eチップ種別.HiHatClose, Eチップ種別.HiHatHalfOpen, Eチップ種別.HiHatOpen } },
			{ E演奏レーン.Snare, new List<Eチップ種別>() { Eチップ種別.Snare, Eチップ種別.SnareClosedRim, Eチップ種別.SnareGhost, Eチップ種別.SnareOpenRim } },
			{ E演奏レーン.Tom1, new List<Eチップ種別>() { Eチップ種別.Tom1, Eチップ種別.Tom1Rim } },
			{ E演奏レーン.Bass, new List<Eチップ種別>() { Eチップ種別.Bass } },
			{ E演奏レーン.Tom2, new List<Eチップ種別>() { Eチップ種別.Tom2, Eチップ種別.Tom2Rim } },
			{ E演奏レーン.Tom3, new List<Eチップ種別>() { Eチップ種別.Tom3, Eチップ種別.Tom3Rim } },
			{ E演奏レーン.RightCymbal, new List<Eチップ種別>() { Eチップ種別.RightCrash, Eチップ種別.RightChina, Eチップ種別.RightCymbalMute, Eチップ種別.RightRide, Eチップ種別.RightRideCup, Eチップ種別.RightSplash } },
			{ E演奏レーン.Unknown, new List<Eチップ種別>() },
		};
		//-------------------------
		#endregion
		#region [ E演奏レーン to 中央位置X（static）]
		//-------------------------
		public static readonly Dictionary<E演奏レーン, int> dic演奏レーンto中央Xpt = new Dictionary<E演奏レーン, int>() {
			{ E演奏レーン.LeftCymbal, 656 },
			{ E演奏レーン.HiHat, 742 },
			{ E演奏レーン.FootPedal, 742 },
			{ E演奏レーン.Snare, 834 },
			{ E演奏レーン.Tom1, 929 },
			{ E演奏レーン.Bass, 1000 },
			{ E演奏レーン.Tom2, 1068 },
			{ E演奏レーン.Tom3, 1164 },
			{ E演奏レーン.RightCymbal, 1251 },
			{ E演奏レーン.Unknown, 0 },
		};
		//-------------------------
		#endregion

		private int n指定された時間msに対応する符号付きピクセル数を返す( long n指定時間ms )
		{
			return (int) ( n指定時間ms * Song.db基準譜面速度pxms * Global.Users.SelectedUser.Options.fスクロールスピード );
		}
	}
}
